/*
  LuxTag Surface Integrator.js
  
  
*/

// global variables.
var version_num = "0.1";

var surface_integrator_types = ["directlighting", "path", "bidirectional", "exphotonmap", "distributedpath" ];
var si_strategy = ["auto", "all", "one"];
var rr_strategy = ["efficiency", "probability", "none"];

var ep_renderingmode = ["directlighting", "path"];

function buildUI( tag ) {
	
	tag.addParameterSeparator("[ Surface Integrator ]");
	
	tag.addParameterSelector("surface integrator type", surface_integrator_types, true, false);
	
	tag.addParameterSeparator("directlighting option");
	
	tag.addParameterInt("dl::maxdepth", 8, 0, 2048, true, false);
	tag.addParameterSelector("dl::strategy", si_strategy, true, false);
	
	tag.addParameterSeparator("path option");
	
	tag.addParameterInt("path::maxdepth", 16, 1, 5*1024, true, false);
	tag.addParameterSelector("path::strategy", si_strategy, true, false);
	tag.addParameterSelector("path::rrstrategy", rr_strategy, true, false);
	tag.addParameterFloat("path::rrcontinueprob", 0.65, 0, 1, true, false);
	tag.addParameterBool("path::includeenviron", 1, 0, 1, true, false);
	
	tag.addParameterSeparator("bidirectional option");
	
	tag.addParameterInt("bd::eyedepth", 16, 0, 2048, true, false);
	tag.addParameterInt("bd::lightdepth", 16, 0, 2048, true, false);
	tag.addParameterSelector("bd::strategy", si_strategy, true, false);
	
	tag.addParameterSeparator("exphotonmap option");
	
	tag.addParameterInt("ep::indirectphotons", 200000, 0, 10000000, true, false);
	tag.addParameterInt("ep::maxdirectphotons", 1000000, 0, 1000000, true, false);
	tag.addParameterInt("ep::causticphotons", 20000, 0, 10000000, true, false);
	
	tag.addParameterSelector("ep::strategy", si_strategy, true, false);
	tag.addParameterInt("ep::maxdepth", 6, 1, 1024, true, false);
	tag.addParameterFloat("ep::maxdist", 0.1, 0, 10, true, false);
	tag.addParameterInt("ep::nused", 50, 1, 50*1000, true, false);
	tag.addParameterSelector("ep::renderingmode", ep_renderingmode, true, false);
	
	tag.addParameterBool("ep::finalgather", 1, 0, 1, true, false);
	tag.addParameterInt("ep::finalgathersamples", 32, 1, 32*1024, true, false);
	tag.addParameterSelector("ep::gatherrrstrategy", rr_strategy, true, false);
	tag.addParameterFloat("ep::gatherangle", 10.0, -360, 360, true, false);
	tag.addParameterFloat("ep::gatherrrcontinueprob", 0.65, 0, 1, true, false);
	
	tag.addParameterSeparator("distributedpath option");
	
	tag.addParameterSelector("dp::strategy", si_strategy, true, false);
	
	tag.addParameterBool("dp::directsampleall", 1, 0, 1, true, false);
	tag.addParameterInt("dp::directsamples", 1, 0, 1024, true, false);
	tag.addParameterBool("dp::indirectsampleall", 0, 0, 1, true, false);
	tag.addParameterInt("dp::indirectsamples", 1, 0, 1024, true, false);
	
	tag.addParameterInt("dp::diffusereflectdepth", 3, 0, 2048, true, false);
	tag.addParameterInt("dp::diffusereflectsamples", 1, 0, 1024, true, false);
	tag.addParameterInt("dp::diffuserefractdepth", 5, 0, 2048, true, false);
	tag.addParameterInt("dp::diffuserefractsamples", 1, 0, 1024, true, false);
	tag.addParameterBool("dp::directdiffuse", 1, 0, 1, true, false);
	tag.addParameterBool("dp::indirectdiffuse", 1, 0, 1, true, false);
	
	tag.addParameterInt("dp::glossyreflectdepth", 3, 0, 2048, true, false);
	tag.addParameterInt("dp::glossyreflectsamples", 1, 0, 1024, true, false);
	tag.addParameterInt("dp::glossyrefractdepth", 5, 0, 2048, true, false);
	tag.addParameterInt("dp::glossyrefractsamples", 1, 0, 1024, true, false);
	tag.addParameterBool("dp::directglossy", 1, 0, 1, true, false);
	tag.addParameterBool("dp::indirectglossy", 1, 0, 1, true, false);
	
	tag.addParameterInt("dp::specularreflectdepth", 3, 0, 2048, true, false);
	tag.addParameterInt("dp::specularrefractdepth", 5, 0, 2048, true, false);
	
	tag.addParameterBool("dp::usereject", 0, 0, 1, true, false);
	
	tag.addParameterBool("dp::diffusereflectreject", 0, 0, 1, true, false);
	tag.addParameterFloat("dp::diffusereflectreject_threshold", 10, 0.01, 10, true, false);
	tag.addParameterBool("dp::diffuserefractreject", 0, 0, 1, true, false);
	tag.addParameterFloat("dp::diffuserefractreject_threshold", 10, 0.01, 10, true, false);
	tag.addParameterBool("dp::glossyreflectreject", 0, 0, 1, true, false);
	tag.addParameterFloat("dp::glossyreflectreject_threshold", 10, 0.01, 10, true, false);
	tag.addParameterBool("dp::glossyrefractreject", 0, 0, 1, true, false);
	tag.addParameterFloat("dp::glossyrefractreject_threshold", 10, 0.01, 10, true, false);
	
}
